/*
 * Decompiled with CFR 0.152.
 */
package net.pevori.queencats.gui.menu;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.pevori.queencats.entity.custom.HumanoidAnimalEntity;
import net.pevori.queencats.gui.menu.ModMenuTypes;

public class HumanoidAnimalMenu
extends AbstractContainerMenu {
    private SimpleContainer inventory;
    private int entityId;
    private HumanoidAnimalEntity entity;

    public HumanoidAnimalMenu(int syncId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(syncId, playerInventory, (HumanoidAnimalEntity)Minecraft.m_91087_().f_91073_.m_6815_(buf.readInt()));
        this.entityId = buf.readInt();
        this.inventory = new SimpleContainer(19);
        this.entity = (HumanoidAnimalEntity)playerInventory.f_35978_.f_19853_.m_6815_(this.entityId);
        this.inventory.m_5856_(playerInventory.f_35978_);
    }

    public HumanoidAnimalMenu(int syncId, Inventory playerInventory, HumanoidAnimalEntity entity) {
        super((MenuType)ModMenuTypes.HUMANOID_ANIMAL_MENU.get(), syncId);
        SimpleContainer entityInventory = entity.getInventory();
        HumanoidAnimalMenu.m_38869_((Container)entityInventory, (int)entity.getInventorySize());
        this.inventory = entityInventory;
        this.m_38897_(this.getCustomArmorSlot());
        this.addHumanoidAnimalInventory(this.inventory);
        this.addPlayerInventory(playerInventory);
    }

    private void addHumanoidAnimalInventory(SimpleContainer inventory) {
        for (int m = 0; m < 3; ++m) {
            for (int l = 0; l < this.getInventoryColumns(); ++l) {
                this.m_38897_(new Slot((Container)inventory, 1 + l + m * this.getInventoryColumns(), 62 + l * 18, 18 + m * 18));
            }
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int m;
        for (m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + m * 9 + 9, 8 + l * 18, 84 + m * 18));
            }
        }
        for (m = 0; m < 9; ++m) {
            this.m_38897_(new Slot((Container)playerInventory, m, 8 + m * 18, 142));
        }
    }

    public ItemStack m_7648_(Player pPlayer, int invSlot) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(invSlot);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int i = this.inventory.m_6643_();
            if (invSlot < i) {
                if (!this.m_38903_(itemstack1, i, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.m_38853_(1).m_5857_(itemstack1) && !this.m_38853_(1).m_6657_()) {
                if (!this.m_38903_(itemstack1, 1, 2, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.m_38853_(0).m_5857_(itemstack1)) {
                if (!this.m_38903_(itemstack1, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (i <= 2 || !this.m_38903_(itemstack1, 2, i, false)) {
                int j = i + 27;
                int k = j + 9;
                if (invSlot >= j && invSlot < k ? !this.m_38903_(itemstack1, i, j, false) : (invSlot >= i && invSlot < j ? !this.m_38903_(itemstack1, j, k, false) : !this.m_38903_(itemstack1, j, j, false))) {
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player pPlayer) {
        return this.inventory.m_6542_(pPlayer);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.inventory.m_5785_(player);
    }

    public HumanoidAnimalEntity getEntity() {
        return this.entity;
    }

    public int getInventoryColumns() {
        return 6;
    }

    public Slot getCustomArmorSlot() {
        return new Slot((Container)this.inventory, 0, 8, 36){

            public boolean m_5857_(ItemStack stack) {
                return HumanoidAnimalMenu.this.isValidArmor(stack);
            }

            public boolean m_6659_() {
                return HumanoidAnimalMenu.this.entity.hasArmorSlot();
            }

            public int m_6641_() {
                return 1;
            }
        };
    }

    public boolean isValidArmor(ItemStack itemStack) {
        ArmorItem item;
        Item item2 = itemStack.m_41720_();
        return item2 instanceof ArmorItem && (item = (ArmorItem)item2).m_40402_() == EquipmentSlot.CHEST;
    }
}

